#ifndef MCF_CONFIGURATION_H_
#define MCF_CONFIGURATION_H_

/*
 * MCF8316AEVM I2C configuration
 */
#define EEPROM_ARRAY_SIZE 24

/*define EEPROM register*/
#define ISD_CONFIG          0x80
#define REV_DRIVE_CONFIG    0x82
#define MOTOR_STARTUP1      0x84
#define MOTOR_STARTUP2      0x86
#define CLOSED_LOOP1        0x88
#define CLOSED_LOOP2        0x8A
#define CLOSED_LOOP3        0x8C
#define CLOSED_LOOP4        0x8E
#define FAULT_CONFIG1       0x90
#define FAULT_CONFIG2       0x92
#define REF_PROFILES1       0x94
#define REF_PROFILES2       0x96
#define REF_PROFILES3       0x98
#define REF_PROFILES4       0x9A
#define REF_PROFILES5       0x9C
#define REF_PROFILES6       0x9E
#define INT_ALGO_1          0xA0
#define INT_ALGO_2          0xA2
#define PIN_CONFIG          0xA4
#define DEVICE_CONFIG1      0xA6
#define DEVICE_CONFIG2      0xA8
#define PERI_CONFIG1        0xAA
#define GD_CONFIG1          0xAC
#define GD_CONFIG2          0xAE

/*define RAM register*/
#define GATE_DRIVER_FAULT_STATUS    0xE0
#define CONTROLLER_FAULT_STATUS     0xE2
#define ALGO_STATUS                 0xE4
#define MTR_PARAMS                  0xE6
#define ALGO_STATUS_MPET            0xE8
#define ALGO_CTRL1                  0xEA
#define ALGO_DEBUG1                 0xEC
#define ALGO_DEBUG2                 0xEE
#define CURRENT_PI                  0xF0
#define SPEED_PI                    0xF2
#define DAC_1                       0xF4
#define DAC_2                       0xF6
#define EEPROM_SECURITY             0xF8
#define EEPROM_FAULT_STATUS         0x32C
#define ALGORITHM_STATE             0x18E
#define FG_SPEED_FDBK               0x194
#define VBETA                       0x400
#define BUS_CURRENT                 0x40C
#define PHASE_CURRENT_A             0x444
#define PHASE_CURRENT_B             0x446
#define PHASE_CURRENT_C             0x448
#define CSA_GAIN_FEEDBACK           0x46C
#define VOLTAGE_GAIN_FEEDBACK       0x477
#define VM_VOLTAGE                  0x47C
#define PHASE_VOLTAGE_VA            0x484
#define PHASE_VOLTAGE_VB            0x486
#define PHASE_VOLTAGE_VC            0x488
#define SIN_COMMUTATION_ANGLE       0x4BC
#define COS_COMMUTATION_ANGLE       0x4BE
#define IALPHA                      0x4DC
#define IBETA                       0x4DE
#define VALPHA                      0x4E0
#define ID                          0x4EC
#define IQ                          0x4EE
#define VD                          0x4F0


/*Values below are example default register settings*/
/*Change the below register map settings to your desired settings*/
unsigned long eeprom_regmap[EEPROM_ARRAY_SIZE][2] = {
    {ISD_CONFIG, 0x4C638C4C},         // ISD_CONFIG
    {REV_DRIVE_CONFIG, 0x30200000},   // REV_DRIVE_CONFIG
    {MOTOR_STARTUP1, 0x4B6847D5},     // MOTOR_STARTUP1
    {MOTOR_STARTUP2, 0x2305C000},     // MOTOR_STARTUP2
    {CLOSED_LOOP1, 0x4C3181B4},       // CLOSED_LOOP1
    {CLOSED_LOOP2, 0x1BAD7A43},       // CLOSED_LOOP2    0x1BAD7B43
    {CLOSED_LOOP3, 0x34800002},       // CLOSED_LOOP3    0x48800002
    {CLOSED_LOOP4, 0x3A8E8960},       // CLOSED_LOOP4    0x2E8B8960
    {FAULT_CONFIG1, 0x7FFA802E},      // FAULT_CONFIG1
    {FAULT_CONFIG2, 0x74028005},      // FAULT_CONFIG2
    {REF_PROFILES1, 0x00000000},      // SPEED_PROFILES1
    {REF_PROFILES2, 0x00000000},      // SPEED_PROFILES2
    {REF_PROFILES3, 0x00000000},      // SPEED_PROFILES3
    {REF_PROFILES4, 0x00000000},      // SPEED_PROFILES4
    {REF_PROFILES5, 0x00000000},      // SPEED_PROFILES5
    {REF_PROFILES6, 0x00000000},      // SPEED_PROFILES6
    {INT_ALGO_1, 0x00B34365},         // INT_ALGO_1
    {INT_ALGO_2, 0x000001A7},         // INT_ALGO_2
    {PIN_CONFIG, 0x00000002},         // PIN_CONFIG,SPEED_MODE->iic
    {DEVICE_CONFIG1, 0x00100003},     // DEVICE_CONFIG1: i2c address
    {DEVICE_CONFIG2, 0x2328D000},     // DEVICE_CONFIG2
    {PERI_CONFIG1, 0x00080000},       // PERI_CONFIG1: direction  fwd 0x480C0000   bwd 0x48140000  hw  0x48040000
    {GD_CONFIG1, 0x0C000100},         // GD_CONFIG1
    {GD_CONFIG2, 0x80000000},         // GD_CONFIG2

};

#endif /* MCF_CONFIGURATION_H_ */
